
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    steaks = m.addVar(vtype=gp.GRB.INTEGER, name="steaks")
    cantaloupes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
    green_beans = m.addVar(vtype=gp.GRB.CONTINUOUS, name="green_beans")
    oreos = m.addVar(vtype=gp.GRB.INTEGER, name="oreos")

    # Set objective function
    m.setObjective(4*steaks + 9*cantaloupes + 9*green_beans + 3*oreos, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*green_beans + 12*oreos >= 22)
    m.addConstr(3*steaks + 3*green_beans >= 35)
    m.addConstr(3*steaks + 12*oreos >= 34)
    m.addConstr(3*steaks + 2*cantaloupes >= 37)
    m.addConstr(2*cantaloupes + 12*oreos >= 42)
    m.addConstr(2*cantaloupes + 3*green_beans >= 32)
    m.addConstr(3*steaks + 3*green_beans + 12*oreos >= 47)
    m.addConstr(3*steaks + 2*cantaloupes + 3*green_beans >= 47)
    m.addConstr(3*steaks + 3*green_beans + 12*oreos >= 52)
    m.addConstr(3*steaks + 2*cantaloupes + 3*green_beans >= 52)
    m.addConstr(3*steaks + 2*cantaloupes + 3*green_beans + 12*oreos >= 52)
    m.addConstr(2*cantaloupes + 8*oreos >= 9)
    m.addConstr(12*steaks + 8*oreos >= 14)
    m.addConstr(12*steaks + 10*green_beans >= 23)
    m.addConstr(12*steaks + 2*cantaloupes >= 15)
    m.addConstr(12*steaks + 2*cantaloupes + 10*green_beans + 8*oreos >= 15)
    m.addConstr(-3*steaks + 2*oreos >= 0)
    m.addConstr(9*steaks - 5*green_beans >= 0)
    m.addConstr(2*cantaloupes + 3*green_beans + 12*oreos <= 133)
    m.addConstr(12*steaks + 2*cantaloupes + 10*green_beans <= 32)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')

except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
