
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
steaks = m.addVar(name="steaks", vtype=gp.GRB.INTEGER)
cantaloupes = m.addVar(name="cantaloupes")
green_beans = m.addVar(name="green_beans")
oreos = m.addVar(name="oreos", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(4 * steaks + 9 * cantaloupes + 9 * green_beans + 3 * oreos, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(3 * steaks <= 208)
m.addConstr(12 * steaks <= 106)
m.addConstr(2 * cantaloupes <= 208)
m.addConstr(2 * cantaloupes <= 106)
m.addConstr(3 * green_beans <= 208)
m.addConstr(10 * green_beans <= 106)
m.addConstr(12 * oreos <= 208)
m.addConstr(8 * oreos <= 106)
m.addConstr(3 * green_beans + 12 * oreos >= 22)
m.addConstr(3 * steaks + 3 * green_beans >= 35)
m.addConstr(3 * steaks + 12 * oreos >= 34)
m.addConstr(3 * steaks + 2 * cantaloupes >= 37)
m.addConstr(2 * cantaloupes + 12 * oreos >= 42)
m.addConstr(2 * cantaloupes + 3 * green_beans >= 32)
m.addConstr(3 * steaks + 3 * green_beans + 12 * oreos >= 47)
m.addConstr(3 * steaks + 2 * cantaloupes + 3 * green_beans >= 47)
m.addConstr(3 * steaks + 3 * green_beans + 12 * oreos >= 52)
m.addConstr(3 * steaks + 2 * cantaloupes + 3 * green_beans >= 52)
m.addConstr(3 * steaks + 2 * cantaloupes + 3 * green_beans + 12 * oreos >= 52)
m.addConstr(2 * cantaloupes + 8 * oreos >= 9)
m.addConstr(12 * steaks + 8 * oreos >= 14)
m.addConstr(12 * steaks + 10 * green_beans >= 23)
m.addConstr(12 * steaks + 2 * cantaloupes >= 15)
m.addConstr(12 * steaks + 2 * cantaloupes + 10 * green_beans + 8 * oreos >= 15)
m.addConstr(-3 * steaks + 2 * oreos >= 0)
m.addConstr(9 * steaks - 5 * green_beans >= 0)
m.addConstr(2 * cantaloupes + 3 * green_beans + 12 * oreos <= 133)
m.addConstr(12 * steaks + 2 * cantaloupes + 10 * green_beans <= 32)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Steaks: ", steaks.varValue)
    print("Cantaloupes: ", cantaloupes.varValue)
    print("Green Beans: ", green_beans.varValue)
    print("Oreos: ", oreos.varValue)
else:
    print("The model is infeasible")
