
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Labor Cost")

# Create variables
dale_hours = model.addVar(vtype=gp.GRB.INTEGER, name="dale_hours")
ringo_hours = model.addVar(vtype=gp.GRB.INTEGER, name="ringo_hours")
john_hours = model.addVar(vtype=gp.GRB.INTEGER, name="john_hours")
mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")


# Set objective function
model.setObjective(4.84 * dale_hours + 1.71 * ringo_hours + 3.71 * john_hours + 8.3 * mary_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(30 * dale_hours + 27 * ringo_hours >= 54, "c1")
model.addConstr(30 * john_hours + 19 * mary_hours >= 66, "c2")
model.addConstr(27 * ringo_hours + 19 * mary_hours >= 68, "c3")
model.addConstr(27 * ringo_hours + 30 * john_hours >= 118, "c4")
model.addConstr(30 * dale_hours + 19 * mary_hours >= 56, "c5")
model.addConstr(30 * dale_hours + 27 * ringo_hours + 19 * mary_hours >= 73, "c6")
model.addConstr(30 * dale_hours + 27 * ringo_hours + 30 * john_hours + 19 * mary_hours >= 73, "c7")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Dale hours: {dale_hours.x}")
    print(f"Ringo hours: {ringo_hours.x}")
    print(f"John hours: {john_hours.x}")
    print(f"Mary hours: {mary_hours.x}")

elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

