
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")
    green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
    chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")


    # Set objective function
    m.setObjective(1 * milkshakes + 8 * green_beans + 1 * chicken_thighs, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9 * milkshakes + 3 * green_beans >= 24, "iron_constraint1")
    m.addConstr(3 * green_beans + 28 * chicken_thighs >= 18, "iron_constraint2")
    m.addConstr(9 * milkshakes + 3 * green_beans + 28 * chicken_thighs >= 18, "iron_constraint3")
    m.addConstr(9 * milkshakes + 3 * green_beans + 28 * chicken_thighs <= 56, "iron_constraint4")
    
    m.addConstr(17 * milkshakes + 13 * green_beans >= 46, "umami_constraint1")
    m.addConstr(17 * milkshakes + 4 * chicken_thighs >= 38, "umami_constraint2")
    m.addConstr(13 * green_beans + 4 * chicken_thighs >= 31, "umami_constraint3")
    m.addConstr(17 * milkshakes + 13 * green_beans + 4 * chicken_thighs >= 31, "umami_constraint4")
    m.addConstr(13 * green_beans + 4 * chicken_thighs <= 85, "umami_constraint5")
    m.addConstr(17 * milkshakes + 4 * chicken_thighs <= 108, "umami_constraint6")

    m.addConstr(6 * milkshakes - 10 * chicken_thighs >= 0, "constraint7")
    m.addConstr(-9 * milkshakes + 10 * green_beans >= 0, "constraint8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
