
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    milkshakes = model.addVar(lb=0, name="milkshakes", vtype=gurobi.GRB.CONTINUOUS)
    green_beans = model.addVar(lb=0, name="green_beans", vtype=gurobi.GRB.CONTINUOUS)
    chicken_thighs = model.addVar(lb=0, name="chicken_thighs", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(milkshakes + 8 * green_beans + chicken_thighs, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * milkshakes + 3 * green_beans + 28 * chicken_thighs <= 89)
    model.addConstr(17 * milkshakes + 13 * green_beans + 4 * chicken_thighs <= 150)
    model.addConstr(9 * milkshakes + 3 * green_beans >= 24)
    model.addConstr(3 * green_beans + 28 * chicken_thighs >= 18)
    model.addConstr(9 * milkshakes + 3 * green_beans + 28 * chicken_thighs >= 18)
    model.addConstr(17 * milkshakes + 13 * green_beans >= 46)
    model.addConstr(17 * milkshakes + 4 * chicken_thighs >= 38)
    model.addConstr(13 * green_beans + 4 * chicken_thighs >= 31)
    model.addConstr(17 * milkshakes + 13 * green_beans + 4 * chicken_thighs >= 31)
    model.addConstr(6 * milkshakes - 10 * chicken_thighs >= 0)
    model.addConstr(-9 * milkshakes + 10 * green_beans >= 0)
    model.addConstr(9 * milkshakes + 3 * green_beans + 28 * chicken_thighs <= 56)
    model.addConstr(13 * green_beans + 4 * chicken_thighs <= 85)
    model.addConstr(17 * milkshakes + 4 * chicken_thighs <= 108)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milkshakes: {milkshakes.varValue}")
        print(f"Green beans: {green_beans.varValue}")
        print(f"Chicken thighs: {chicken_thighs.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
