
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="airborne_infantry_companies")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="engineer_platoons")


    # Set objective function
    m.setObjective(2.27 * x0 + 4.98 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10 * x0 + 4 * x1 >= 28, "logistics_footprint_min")
    m.addConstr(10 * x0 + 4 * x1 <= 55, "logistics_footprint_max")  # Added max constraint
    m.addConstr(8 * x0 + 10 * x1 >= 34, "logistical_capacity_min")
    m.addConstr(8 * x0 + 10 * x1 <= 69, "logistical_capacity_max")  # Added max constraint
    m.addConstr(6 * x0 + 6 * x1 >= 41, "mobility_rating_min")
    m.addConstr(6 * x0 + 6 * x1 <= 115, "mobility_rating_max")  # Added max constraint
    m.addConstr(6 * x0 - 4 * x1 >= 0, "additional_constraint")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Airborne Infantry Companies: {x0.x}")
        print(f"  Engineer Platoons: {x1.x}")
        print(f"  Objective Value: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
