
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x0 = m.addVar(vtype=GRB.INTEGER, name="airborne_infantry_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="engineer_platoons")

# Set objective function
m.setObjective(2.27*x0 + 4.98*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x0 + 4*x1 >= 28, "logistics_footprint")
m.addConstr(8*x0 + 10*x1 >= 34, "combined_logistical_capacity")
m.addConstr(6*x0 + 6*x1 >= 41, "combined_mobility_rating")
m.addConstr(6*x0 - 4*x1 >= 0, "specific_linear_constraint")
m.addConstr(10*x0 + 4*x1 <= 55, "max_logistics_footprint")
m.addConstr(8*x0 + 10*x1 <= 69, "max_combined_logistical_capacity")
m.addConstr(6*x0 + 6*x1 <= 115, "max_combined_mobility_rating")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Airborne Infantry Companies: {x0.x}")
    print(f"Engineer Platoons: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
