
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="airborne_infantry_companies")
x2 = model.addVar(vtype=gurobi.GRB.INTEGER, name="engineer_platoons")

# Define the objective function
model.setObjective(2.27 * x1 + 4.98 * x2, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(10 * x1 + 4 * x2 >= 28, name="logistics_footprint_min")
model.addConstr(10 * x1 + 4 * x2 <= 76, name="logistics_footprint_max")
model.addConstr(8 * x1 + 10 * x2 >= 34, name="logistical_capacity_min")
model.addConstr(8 * x1 + 10 * x2 <= 69, name="logistical_capacity_max")
model.addConstr(6 * x1 + 6 * x2 >= 41, name="mobility_rating_min")
model.addConstr(6 * x1 + 6 * x2 <= 115, name="mobility_rating_max")
model.addConstr(6 * x1 - 4 * x2 >= 0, name="specific_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Airborne Infantry Companies: ", x1.varValue)
    print("Engineer Platoons: ", x2.varValue)
else:
    print("The model is infeasible")
