
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="military_intelligence_companies")
    x1 = model.addVar(vtype=GRB.INTEGER, name="mechanized_infantry_companies")


    # Set objective function
    model.setObjective(2.69 * x0 + 8.87 * x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.52 * x0 + 0.27 * x1 >= 45, "deployment_weight_min")
    model.addConstr(0.16 * x0 + 0.03 * x1 >= 41, "logistical_capacity_min")
    model.addConstr(-2 * x0 + 10 * x1 >= 0, "constraint3")
    model.addConstr(0.52 * x0 + 0.27 * x1 <= 117, "deployment_weight_max")
    model.addConstr(0.16 * x0 + 0.03 * x1 <= 57, "logistical_capacity_max")



    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Military Intelligence Companies: {x0.x}")
        print(f"Mechanized Infantry Companies: {x1.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check variable usage.")
