
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="military_intelligence_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="mechanized_infantry_companies")

# Set objective function
m.setObjective(2.69*x0 + 8.87*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.52*x0 + 0.27*x1 >= 45, "deployment_weight_min")
m.addConstr(0.16*x0 + 0.03*x1 >= 41, "logistical_capacity_min")
m.addConstr(-2*x0 + 10*x1 >= 0, "company_combination")
m.addConstr(0.52*x0 + 0.27*x1 <= 117, "deployment_weight_max")
m.addConstr(0.16*x0 + 0.03*x1 <= 57, "logistical_capacity_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"military_intelligence_companies: {x0.x}")
    print(f"mechanized_infantry_companies: {x1.x}")
else:
    print("No optimal solution found")
