
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="military_intelligence_companies", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="mechanized_infantry_companies", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(2.69*x1 + 8.87*x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(0.52*x1 + 0.27*x2 >= 45, name="deployment_weight_min")
m.addConstr(0.16*x1 + 0.03*x2 >= 41, name="logistical_capacity_min")
m.addConstr(-2*x1 + 10*x2 >= 0, name="mechanized_infantry_companies_vs_military_intelligence_companies")
m.addConstr(0.52*x1 + 0.27*x2 <= 117, name="deployment_weight_max")
m.addConstr(0.16*x1 + 0.03*x2 <= 57, name="logistical_capacity_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Military intelligence companies: {x1.varValue}")
    print(f"Mechanized infantry companies: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
