
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="medical_platoons")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="mechanized_infantry_companies")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="airborne_infantry_companies")


    # Set objective function
    m.setObjective(8*x0 + 9*x1 + 5*x2 + 5*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11*x0 + 10*x1 + 5*x2 + 12*x3 <= 94, "logistics_footprint")
    m.addConstr(11*x0 + 5*x2 >= 17, "cbrn_mech_footprint")
    m.addConstr(10*x1 + 12*x3 >= 12, "medical_airborne_footprint")
    m.addConstr(11*x0 + 12*x3 >= 17, "cbrn_airborne_footprint")
    m.addConstr(5*x2 + 12*x3 >= 16, "mech_airborne_footprint")
    m.addConstr(10*x1 + 5*x2 >= 13, "medical_mech_footprint")
    m.addConstr(11*x0 + 10*x1 + 5*x2 + 12*x3 >= 13, "min_total_footprint")
    m.addConstr(10*x1 - 10*x2 >= 0, "medical_mech_ratio")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
