
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="medical_platoons", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="mechanized_infantry_companies", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="airborne_infantry_companies", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(8 * x1 + 9 * x2 + 5 * x3 + 5 * x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11 * x1 <= 94)
    model.addConstr(10 * x2 <= 94)
    model.addConstr(5 * x3 <= 94)
    model.addConstr(12 * x4 <= 94)
    model.addConstr(11 * x1 + 5 * x3 >= 17)
    model.addConstr(10 * x2 + 12 * x4 >= 12)
    model.addConstr(11 * x1 + 12 * x4 >= 17)
    model.addConstr(5 * x3 + 12 * x4 >= 16)
    model.addConstr(10 * x2 + 5 * x3 >= 13)
    model.addConstr(11 * x1 + 10 * x2 + 5 * x3 + 12 * x4 >= 13)
    model.addConstr(10 * x2 - 10 * x3 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("CBRN platoons: ", x1.varValue)
        print("Medical platoons: ", x2.varValue)
        print("Mechanized infantry companies: ", x3.varValue)
        print("Airborne infantry companies: ", x4.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
