
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of vitamin B3
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # milligrams of vitamin B7
    x2 = m.addVar(vtype=GRB.INTEGER, name="x2") # milligrams of iron


    # Set objective function
    m.setObjective(3*x0 + 9*x1 + 4*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(15*x0 + 27*x1 + 27*x2 >= 53, "c0")
    m.addConstr(3*x0 + 10*x2 >= 106, "c1")
    m.addConstr(29*x1 + 10*x2 >= 118, "c2")
    m.addConstr(15*x0 + 27*x2 <= 77, "c3")
    m.addConstr(15*x0 + 27*x1 + 27*x2 <= 77, "c4")
    m.addConstr(3*x0 + 10*x2 <= 146, "c5")
    m.addConstr(29*x1 + 10*x2 <= 248, "c6")
    m.addConstr(3*x0 + 29*x1 + 10*x2 <= 248, "c7")
    m.addConstr(21*x0 + 24*x1 <= 209, "c8")
    m.addConstr(24*x1 + 13*x2 <= 255, "c9")
    m.addConstr(21*x0 + 24*x1 + 13*x2 <= 255, "c10")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Other optimization status code:', m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
