
import gurobi as gp

# Create a new model
model = gp.Model("optimization_problem")

# Define the variables
x0 = model.addVar(name="x0", vtype=gp.GRB.INTEGER)  # milligrams of vitamin B3
x1 = model.addVar(name="x1")  # milligrams of vitamin B7
x2 = model.addVar(name="x2", vtype=gp.GRB.INTEGER)  # milligrams of iron

# Define the objective function
model.setObjective(3*x0 + 9*x1 + 4*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(15*x0 <= 180, name="c1")
model.addConstr(3*x0 <= 379, name="c2")
model.addConstr(21*x0 <= 379, name="c3")
model.addConstr(27*x1 <= 180, name="c4")
model.addConstr(29*x1 <= 379, name="c5")
model.addConstr(24*x1 <= 379, name="c6")
model.addConstr(27*x2 <= 180, name="c7")
model.addConstr(10*x2 <= 379, name="c8")
model.addConstr(13*x2 <= 379, name="c9")
model.addConstr(15*x0 + 27*x1 + 27*x2 >= 53, name="c10")
model.addConstr(3*x0 + 10*x2 >= 106, name="c11")
model.addConstr(29*x1 + 10*x2 >= 118, name="c12")
model.addConstr(15*x0 + 27*x2 <= 77, name="c13")
model.addConstr(15*x0 + 27*x1 + 27*x2 <= 77, name="c14")
model.addConstr(3*x0 + 10*x2 <= 146, name="c15")
model.addConstr(29*x1 + 10*x2 <= 248, name="c16")
model.addConstr(3*x0 + 29*x1 + 10*x2 <= 248, name="c17")
model.addConstr(21*x0 + 24*x1 <= 209, name="c18")
model.addConstr(24*x1 + 13*x2 <= 255, name="c19")
model.addConstr(21*x0 + 24*x1 + 13*x2 <= 255, name="c20")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
