
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("Plant_Optimization")

    # Create variables
    verbenas = m.addVar(vtype=gp.GRB.INTEGER, name="verbenas")
    begonias = m.addVar(vtype=gp.GRB.INTEGER, name="begonias")

    # Set objective function
    m.setObjective(2 * verbenas + 4 * begonias, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11 * verbenas + 5 * begonias >= 8 * 144, "Planting_Space_Min")  # 8 sq ft minimum
    m.addConstr(1 * verbenas + 1 * begonias >= 4, "Resilience_Min")
    m.addConstr(6 * verbenas - 10 * begonias >= 0, "Verbena_Begonia_Ratio")
    m.addConstr(11 * verbenas + 5 * begonias <= 39 * 144, "Planting_Space_Max")  # 39 sq ft maximum
    m.addConstr(1 * verbenas + 1 * begonias <= 15, "Resilience_Max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Verbenas:', verbenas.x)
        print('Begonias:', begonias.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

