
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="verbenas")
x2 = m.addVar(vtype=GRB.INTEGER, name="begonias")

# Set objective function
m.setObjective(2*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7692*x1 + 0.3476*x2 >= 8, "Planting_Space_Min")
m.addConstr(x1 + x2 >= 4, "Resilience_Index_Min")
m.addConstr(6*x1 - 10*x2 >= 0, "Verb_Bego_Constraint")
m.addConstr(0.7692*x1 + 0.3476*x2 <= 39, "Planting_Space_Max")
m.addConstr(x1 + x2 <= 15, "Resilience_Index_Max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Verbenas: {x1.x}")
    print(f"Begonias: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
