
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    verbenas = model.addVar(name='verbenas', vtype=gurobi.GRB.INTEGER)
    begonias = model.addVar(name='begonias', vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 2*verbenas + 4*begonias
    model.setObjective(2 * verbenas + 4 * begonias, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(11 * verbenas + 5 * begonias >= 1152, name='planting_space_min')
    model.addConstr(verbenas + begonias >= 4, name='resilience_index_min')
    model.addConstr(6 * verbenas - 10 * begonias >= 0, name='resilience_index_ratio')
    model.addConstr(11 * verbenas + 5 * begonias <= 5616, name='planting_space_max')
    model.addConstr(verbenas + begonias <= 15, name='resilience_index_max')

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Verbenas: {verbenas.varValue}')
        print(f'Begonias: {begonias.varValue}')
        print(f'Objective: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
