
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
diapers = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
paper_towel_rolls = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")
cookies = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")
toilet_paper_rolls = m.addVar(vtype=gp.GRB.INTEGER, name="toilet_paper_rolls")


# Set objective function
m.setObjective(4 * diapers + 8 * paper_towel_rolls + 9 * cookies + 1 * toilet_paper_rolls, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * diapers + 9 * paper_towel_rolls >= 8)
m.addConstr(10 * cookies + 6 * toilet_paper_rolls >= 5)
m.addConstr(9 * paper_towel_rolls + 6 * toilet_paper_rolls >= 8)
m.addConstr(1 * diapers + 10 * cookies + 6 * toilet_paper_rolls >= 15)
m.addConstr(1 * diapers + 9 * paper_towel_rolls + 6 * toilet_paper_rolls >= 15)
m.addConstr(1 * diapers + 9 * paper_towel_rolls + 10 * cookies >= 15)
m.addConstr(1 * diapers + 10 * cookies + 6 * toilet_paper_rolls >= 8)
m.addConstr(1 * diapers + 9 * paper_towel_rolls + 6 * toilet_paper_rolls >= 8)
m.addConstr(1 * diapers + 9 * paper_towel_rolls + 10 * cookies >= 8)
m.addConstr(1 * diapers + 10 * cookies + 6 * toilet_paper_rolls >= 10)
m.addConstr(1 * diapers + 9 * paper_towel_rolls + 6 * toilet_paper_rolls >= 10)
m.addConstr(1 * diapers + 9 * paper_towel_rolls + 10 * cookies >= 10)
m.addConstr(1 * diapers + 9 * paper_towel_rolls + 10 * cookies + 6 * toilet_paper_rolls >= 10)
m.addConstr(4 * paper_towel_rolls + 7 * toilet_paper_rolls >= 12)
m.addConstr(6 * diapers + 4 * paper_towel_rolls >= 8)
m.addConstr(6 * diapers + 7 * toilet_paper_rolls >= 10)
m.addConstr(6 * diapers + 4 * paper_towel_rolls + 9 * cookies + 7 * toilet_paper_rolls >= 10)
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

