
import gurobi

m = gurobi.Model()

x0 = m.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="paper towel rolls", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="cookies", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="toilet paper rolls", vtype=gurobi.GRB.INTEGER)

m.setObjective(4*x0 + 8*x1 + 9*x2 + x3, gurobi.GRB.MINIMIZE)

m.addConstr(x0 + 9*x1 >= 8)
m.addConstr(10*x2 + 6*x3 >= 5)
m.addConstr(9*x1 + 6*x3 >= 8)
m.addConstr(x0 + 10*x2 + 6*x3 >= 15)
m.addConstr(x0 + 9*x1 + 6*x3 >= 15)
m.addConstr(x0 + 9*x1 + 10*x2 >= 15)
m.addConstr(x0 + 10*x2 + 6*x3 >= 8)
m.addConstr(x0 + 9*x1 + 6*x3 >= 8)
m.addConstr(x0 + 9*x1 + 10*x2 >= 8)
m.addConstr(x0 + 10*x2 + 6*x3 >= 10)
m.addConstr(x0 + 9*x1 + 6*x3 >= 10)
m.addConstr(x0 + 9*x1 + 10*x2 >= 10)
m.addConstr(x0 + 9*x1 + 10*x2 + 6*x3 >= 10)
m.addConstr(4*x1 + 7*x3 >= 12)
m.addConstr(6*x0 + 4*x1 >= 8)
m.addConstr(6*x0 + 7*x3 >= 10)
m.addConstr(6*x0 + 4*x1 + 9*x2 + 7*x3 >= 10)
m.addConstr(7*x0 + 11*x1 >= 12)
m.addConstr(7*x0 + 11*x1 + 5*x2 >= 14)
m.addConstr(5*x2 + x3 >= 9)
m.addConstr(11*x1 + x3 >= 15)
m.addConstr(7*x0 + 11*x1 + 5*x2 >= 8)
m.addConstr(7*x0 + 5*x2 + x3 >= 8)
m.addConstr(11*x1 + 5*x2 + x3 >= 8)
m.addConstr(7*x0 + 11*x1 + 5*x2 >= 11)
m.addConstr(7*x0 + 5*x2 + x3 >= 11)
m.addConstr(11*x1 + 5*x2 + x3 >= 11)
m.addConstr(7*x0 + 11*x1 + 5*x2 >= 16)
m.addConstr(7*x0 + 5*x2 + x3 >= 16)
m.addConstr(11*x1 + 5*x2 + x3 >= 16)
m.addConstr(7*x0 + 11*x1 + 5*x2 + x3 >= 16)
m.addConstr(3*x2 + 5*x3 >= 18)
m.addConstr(4*x0 + 3*x2 >= 8)
m.addConstr(4*x0 + 10*x1 + 5*x3 >= 14)
m.addConstr(4*x0 + 10*x1 + 3*x2 + 5*x3 >= 14)
m.addConstr(10*x1 + 9*x3 >= 16)
m.addConstr(x0 + 9*x3 >= 8)
m.addConstr(x0 + 10*x1 >= 17)
m.addConstr(3*x2 + 9*x3 >= 16)
m.addConstr(10*x1 + 11*x2 >= 15)
m.addConstr(x0 + 11*x2 >= 19)
m.addConstr(x0 + 10*x1 + 9*x3 >= 17)
m.addConstr(x0 + 10*x1 + 11*x2 >= 17)
m.addConstr(x0 + 11*x2 + 9*x3 >= 17)
m.addConstr(x0 + 10*x1 + 9*x3 >= 15)
m.addConstr(x0 + 11*x2 + 9*x3 >= 15)
m.addConstr(x0 + 10*x1 + 11*x2 >= 15)
m.addConstr(x0 + 10*x1 + 11*x2 + 9*x3 >= 13)
m.addConstr(-8*x1 + 9*x3 >= 0)
m.addConstr(3*x1 - 7*x2 >= 0)
m.addConstr(x0 + 10*x2 + 6*x3 <= 48)
m.addConstr(x0 + 9*x1 + 6*x3 <= 30)
m.addConstr(9*x1 + 10*x2 + 6*x3 <= 49)
m.addConstr(6*x0 + 4*x1 <= 45)
m.addConstr(6*x0 + 9*x2 + 7*x3 <= 57)
m.addConstr(4*x1 + 9*x2 + 7*x3 <= 57)
m.addConstr(6*x0 + 4*x1 + 9*x2 <= 39)
m.addConstr(6*x0 + 4*x1 + 7*x3 <= 22)
m.addConstr(7*x0 + 11*x1 + 5*x2 <= 61)
m.addConstr(11*x1 + 5*x2 + x3 <= 46)
m.addConstr(7*x0 + 11*x1 + x3 <= 20)
m.addConstr(3*x2 + 5*x3 <= 36)
m.addConstr(4*x0 + 3*x2 <= 70)
m.addConstr(10*x1 + 5*x3 <= 50)
m.addConstr(10*x1 + 11*x2 <= 36)
m.addConstr(x0 + 9*x3 <= 39)
m.addConstr(x0 + 10*x1 + 9*x3 <= 43)
m.addConstr(10*x1 + 11*x2 + 9*x3 <= 41)
m.addConstr(x0 + 11*x2 + 9*x3 <= 57)
m.addConstr(x0 + 10*x1 + 11*x2 <= 63)

m.optimize()

if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Diapers: ", x0.varValue)
    print("Paper Towel Rolls: ", x1.varValue)
    print("Cookies: ", x2.varValue)
    print("Toilet Paper Rolls: ", x3.varValue)
else:
    print("No solution found")
