
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
magnesium = m.addVar(vtype=gp.GRB.INTEGER, name="magnesium")
vitamin_b2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
vitamin_k = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_k")
vitamin_d = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
fiber = m.addVar(vtype=gp.GRB.INTEGER, name="fiber")
calcium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="calcium")


# Set objective function
m.setObjective(4 * magnesium + 3 * vitamin_b2 + 1 * vitamin_k + 1 * vitamin_d + 5 * fiber + 6 * calcium, gp.GRB.MINIMIZE)

# Cardiovascular support index constraints (r0)
cardiovascular_support_index = {
    'magnesium': 7,
    'vitamin_b2': 3,
    'vitamin_k': 1,
    'vitamin_d': 3,
    'fiber': 9,
    'calcium': 10
}

# Digestive support index constraints (r1)
digestive_support_index = {
    'magnesium': 10,
    'vitamin_b2': 8,
    'vitamin_k': 5,
    'vitamin_d': 7,
    'fiber': 8,
    'calcium': 7
}

r0_upper_bound = 128
r1_upper_bound = 101


# Add constraints based on the JSON representation
with open('constraints.json', 'r') as f:
    import json
    data = json.load(f)

variables = {
    'x0': magnesium,
    'x1': vitamin_b2,
    'x2': vitamin_k,
    'x3': vitamin_d,
    'x4': fiber,
    'x5': calcium
}

for constraint in data['constraints']:
    m.addConstr(eval(constraint, variables))


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

