
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")


# Set objective function
m.setObjective(1.99 * vitamin_d + 4.21 * fiber + 6.01 * vitamin_b5, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * fiber + 10 * vitamin_b5 <= 58, "c1")
m.addConstr(9 * vitamin_d + 8 * fiber <= 33, "c2")
m.addConstr(9 * vitamin_d + 8 * fiber + 10 * vitamin_b5 <= 33, "c3")
m.addConstr(1 * fiber + 10 * vitamin_b5 <= 37, "c4")
m.addConstr(7 * vitamin_d + 1 * fiber <= 38, "c5")
m.addConstr(7 * vitamin_d + 10 * vitamin_b5 <= 31, "c6")
m.addConstr(7 * vitamin_d + 1 * fiber + 10 * vitamin_b5 <= 31, "c7")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_d:', vitamin_d.x)
    print('fiber:', fiber.x)
    print('vitamin_b5:', vitamin_b5.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

