
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_D", lb=0)
    x1 = model.addVar(name="grams_of_fiber", lb=0)
    x2 = model.addVar(name="milligrams_of_vitamin_B5", lb=0)

    # Define the objective function
    model.setObjective(1.99*x0 + 4.21*x1 + 6.01*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(9*x0 <= 82)
    model.addConstr(7*x0 <= 90)
    model.addConstr(8*x1 <= 82)
    model.addConstr(x1 <= 90)
    model.addConstr(10*x2 <= 82)
    model.addConstr(10*x2 <= 90)
    model.addConstr(8*x1 + 10*x2 <= 58)
    model.addConstr(9*x0 + 8*x1 <= 33)
    model.addConstr(9*x0 + 8*x1 + 10*x2 <= 33)
    model.addConstr(x1 + 10*x2 <= 37)
    model.addConstr(7*x0 + x1 <= 38)
    model.addConstr(7*x0 + 10*x2 <= 31)
    model.addConstr(7*x0 + x1 + 10*x2 <= 31)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x0.varValue}")
        print(f"Grams of fiber: {x1.varValue}")
        print(f"Milligrams of vitamin B5: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
