
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    john_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")
    paul_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")


    # Set objective function
    model.setObjective(8 * john_hours + 5 * paul_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1 * john_hours + 22 * paul_hours >= 57, "paperwork_min")
    model.addConstr(5 * john_hours + 28 * paul_hours >= 31, "organization_min")
    model.addConstr(11 * john_hours + 21 * paul_hours >= 43, "cost_min")
    model.addConstr(-3 * john_hours + 10 * paul_hours >= 0, "custom_constraint")
    model.addConstr(1 * john_hours + 22 * paul_hours <= 86, "paperwork_max")
    model.addConstr(5 * john_hours + 28 * paul_hours <= 124, "organization_max")
    model.addConstr(11 * john_hours + 21 * paul_hours <= 60, "cost_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by John: {john_hours.x}")
        print(f"Hours worked by Paul: {paul_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
