
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_John")
x2 = m.addVar(lb=0, name="hours_worked_by_Paul")

# Set the objective function
m.setObjective(8*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 22*x2 >= 57, "paperwork_competence_rating")
m.addConstr(5*x1 + 28*x2 >= 31, "organization_score")
m.addConstr(11*x1 + 21*x2 >= 43, "dollar_cost_per_hour")
m.addConstr(-3*x1 + 10*x2 >= 0, "linear_constraint")
m.addConstr(x1 + 22*x2 <= 86, "upper_bound_paperwork")
m.addConstr(5*x1 + 28*x2 <= 124, "upper_bound_organization")
m.addConstr(11*x1 + 21*x2 <= 60, "upper_bound_dollar_cost")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by John: {x1.x}")
    print(f"Hours worked by Paul: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
