
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_John", lb=0)  # Assuming non-negativity
    x2 = model.addVar(name="hours_worked_by_Paul", lb=0)

    # Define the objective function
    model.setObjective(8 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1 * x1 + 22 * x2 >= 57)  # paperwork competence rating minimum
    model.addConstr(5 * x1 + 28 * x2 >= 31)  # organization score minimum
    model.addConstr(11 * x1 + 21 * x2 >= 43)  # dollar cost per hour minimum
    model.addConstr(-3 * x1 + 10 * x2 >= 0)  # linear combination of hours worked
    model.addConstr(1 * x1 + 22 * x2 <= 86)  # paperwork competence rating maximum
    model.addConstr(5 * x1 + 28 * x2 <= 124)  # organization score maximum
    model.addConstr(11 * x1 + 21 * x2 <= 60)  # dollar cost per hour maximum

    # Optimize the model
    model.optimize()

    # Print the status of the model
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by John: {x1.x}")
        print(f"Hours worked by Paul: {x2.x}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
