
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bobby_hours = model.addVar(vtype=GRB.INTEGER, name="bobby_hours")
    peggy_hours = model.addVar(vtype=GRB.CONTINUOUS, name="peggy_hours")


    # Set objective function
    model.setObjective(bobby_hours + peggy_hours, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * bobby_hours + 5 * peggy_hours >= 6, "work_quality_min")
    model.addConstr(2 * bobby_hours + 8 * peggy_hours >= 10, "organization_score_min")
    model.addConstr(-1 * bobby_hours + 6 * peggy_hours >= 0, "constraint3")
    model.addConstr(4 * bobby_hours + 5 * peggy_hours <= 13, "work_quality_max")
    model.addConstr(2 * bobby_hours + 8 * peggy_hours <= 31, "organization_score_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Bobby: {bobby_hours.x}")
        print(f"Hours worked by Peggy: {peggy_hours.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
