
from gurobipy import *

# Create a model
m = Model("Work Hours Optimization")

# Add variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bobby")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")

# Set objective function
m.setObjective(1*x0 + 1*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 5*x1 >= 6, "work_quality_rating_min")
m.addConstr(2*x0 + 8*x1 >= 10, "organization_score_min")
m.addConstr(-1*x0 + 6*x1 >= 0, "peggy_bobby_ratio")
m.addConstr(4*x0 + 5*x1 <= 13, "work_quality_rating_max")
m.addConstr(2*x0 + 8*x1 <= 31, "organization_score_max")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bobby: {x0.x}")
    print(f"Hours worked by Peggy: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
