
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Bobby", vtype=gurobi.GRB.INTEGER)  # Integer variable for Bobby
x2 = m.addVar(name="hours_worked_by_Peggy")  # Continuous variable for Peggy

# Objective function: Maximize x1 + x2
m.setObjective(x1 + x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x1 + 5*x2 >= 6, name="work_quality_rating_constraint")
m.addConstr(2*x1 + 8*x2 >= 10, name="organization_score_constraint")
m.addConstr(-x1 + 6*x2 >= 0, name="bobby_peggy_hours_constraint")
m.addConstr(4*x1 + 5*x2 <= 13, name="max_work_quality_rating_constraint")
m.addConstr(2*x1 + 8*x2 <= 31, name="max_organization_score_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bobby: {x1.varValue}")
    print(f"Hours worked by Peggy: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
