
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
cornichons = m.addVar(vtype=gp.GRB.INTEGER, name="cornichons")
peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
oreos = m.addVar(vtype=gp.GRB.INTEGER, name="oreos")
corn_cobs = m.addVar(vtype=gp.GRB.INTEGER, name="corn_cobs")


# Set objective function
m.setObjective(2.96 * cornichons + 4.19 * peanutbutter_sandwiches + 2.71 * oreos + 7.65 * corn_cobs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * cornichons + 22 * oreos >= 19, "c0")
m.addConstr(25 * peanutbutter_sandwiches + 22 * oreos >= 16, "c1")
m.addConstr(25 * peanutbutter_sandwiches + 23 * corn_cobs >= 17, "c2")
m.addConstr(4 * cornichons + 23 * corn_cobs >= 14, "c3")
m.addConstr(22 * oreos + 23 * corn_cobs >= 23, "c4")
m.addConstr(4 * cornichons + 25 * peanutbutter_sandwiches >= 18, "c5")
m.addConstr(4 * cornichons + 25 * peanutbutter_sandwiches + 23 * corn_cobs >= 25, "c6")
m.addConstr(4 * cornichons + 25 * peanutbutter_sandwiches + 22 * oreos + 23 * corn_cobs >= 25, "c7")
m.addConstr(11 * cornichons + 6 * corn_cobs >= 21, "c8")
m.addConstr(7 * peanutbutter_sandwiches + 6 * corn_cobs >= 11, "c9")
m.addConstr(6 * oreos + 6 * corn_cobs >= 19, "c10")
m.addConstr(7 * peanutbutter_sandwiches + 6 * oreos + 6 * corn_cobs >= 20, "c11")
m.addConstr(11 * cornichons + 7 * peanutbutter_sandwiches + 6 * oreos + 6 * corn_cobs >= 20, "c12")
m.addConstr(14 * cornichons + 26 * peanutbutter_sandwiches >= 44, "c13")
m.addConstr(14 * cornichons + 8 * oreos >= 33, "c14")
m.addConstr(14 * cornichons + 1 * corn_cobs >= 23, "c15")
m.addConstr(8 * oreos + 1 * corn_cobs >= 53, "c16")
m.addConstr(26 * peanutbutter_sandwiches + 8 * oreos >= 37, "c17")
m.addConstr(26 * peanutbutter_sandwiches + 8 * oreos + 1 * corn_cobs >= 44, "c18")
m.addConstr(14 * cornichons + 26 * peanutbutter_sandwiches + 8 * oreos >= 44, "c19")
m.addConstr(14 * cornichons + 8 * oreos + 1 * corn_cobs >= 44, "c20")
m.addConstr(26 * peanutbutter_sandwiches + 8 * oreos + 1 * corn_cobs >= 67, "c21")
m.addConstr(14 * cornichons + 26 * peanutbutter_sandwiches + 8 * oreos >= 67, "c22")
m.addConstr(14 * cornichons + 8 * oreos + 1 * corn_cobs >= 67, "c23")
m.addConstr(26 * peanutbutter_sandwiches + 8 * oreos + 1 * corn_cobs >= 35, "c24")
m.addConstr(14 * cornichons + 26 * peanutbutter_sandwiches + 8 * oreos >= 35, "c25")
m.addConstr(14 * cornichons + 8 * oreos + 1 * corn_cobs >= 35, "c26")
m.addConstr(14 * cornichons + 26 * peanutbutter_sandwiches + 8 * oreos + 1 * corn_cobs >= 35, "c27")
m.addConstr(17 * cornichons + 21 * corn_cobs >= 19, "c28")
m.addConstr(17 * cornichons + 18 * peanutbutter_sandwiches >= 25, "c29")
m.addConstr(16 * oreos + 21 * corn_cobs >= 22, "c30")
m.addConstr(17 * cornichons + 18 * peanutbutter_sandwiches + 16 * oreos + 21 * corn_cobs >= 22, "c31")
m.addConstr(27 * peanutbutter_sandwiches + 23 * corn_cobs >= 36, "c32")
m.addConstr(26 * oreos + 23 * corn_cobs >= 22, "c33")
m.addConstr(20 * cornichons + 27 * peanutbutter_sandwiches + 26 * oreos >= 24, "c34")
m.addConstr(20 * cornichons + 26 * oreos + 23 * corn_cobs >= 24, "c35")
m.addConstr(27 * peanutbutter_sandwiches + 26 * oreos + 23 * corn_cobs >= 24, "c36")
m.addConstr(20 * cornichons + 27 * peanutbutter_sandwiches + 26 * oreos >= 31, "c37")
m.addConstr(20 * cornichons + 26 * oreos + 23 * corn_cobs >= 31, "c38")
m.addConstr(27 * peanutbutter_sandwiches + 26 * oreos + 23 * corn_cobs >= 31, "c39")
m.addConstr(20 * cornichons + 27 * peanutbutter_sandwiches + 26 * oreos >= 31, "c40")
m.addConstr(20 * cornichons + 26 * oreos + 23 * corn_cobs >= 31, "c41")
m.addConstr(27 * peanutbutter_sandwiches + 26 * oreos + 23 * corn_cobs >= 31, "c42")
m.addConstr(20 * cornichons + 27 * peanutbutter_sandwiches + 26 * oreos + 23 * corn_cobs >= 31, "c43")
m.addConstr(7 * cornichons - 1 * peanutbutter_sandwiches >= 0, "c44")
m.addConstr(7 * peanutbutter_sandwiches + 6 * corn_cobs <= 112, "c45")
m.addConstr(6 * oreos + 6 * corn_cobs <= 39, "c46")
m.addConstr(11 * cornichons + 6 * corn_cobs <= 111, "c47")
m.addConstr(11 * cornichons + 6 * oreos <= 83, "c48")
m.addConstr(17 * cornichons + 18 * peanutbutter_sandwiches <= 42, "c49")
m.addConstr(16 * oreos + 21 * corn_cobs <= 78, "c50")
m.addConstr(20 * cornichons + 26 * oreos + 23 * corn_cobs <= 37, "c51")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

