
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="cornichons", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="peanutbutter_sandwiches")
x2 = m.addVar(name="oreos", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="corn_cobs", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(2.96*x0 + 4.19*x1 + 2.71*x2 + 7.65*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x0 + 22*x2 >= 19)
m.addConstr(25*x1 + 22*x2 >= 16)
m.addConstr(25*x1 + 23*x3 >= 17)
m.addConstr(4*x0 + 23*x3 >= 14)
m.addConstr(22*x2 + 23*x3 >= 23)
m.addConstr(4*x0 + 25*x1 >= 18)
m.addConstr(4*x0 + 25*x1 + 23*x3 >= 25)
m.addConstr(11*x0 + 6*x3 >= 21)
m.addConstr(7*x1 + 6*x3 >= 11)
m.addConstr(6*x2 + 6*x3 >= 19)
m.addConstr(7*x1 + 6*x2 + 6*x3 >= 20)
m.addConstr(11*x0 + 7*x1 + 6*x2 + 6*x3 >= 20)
m.addConstr(14*x0 + 26*x1 >= 44)
m.addConstr(14*x0 + 8*x2 >= 33)
m.addConstr(14*x0 + x3 >= 23)
m.addConstr(8*x2 + x3 >= 53)
m.addConstr(26*x1 + 8*x2 >= 37)
m.addConstr(26*x1 + 8*x2 + x3 >= 44)
m.addConstr(14*x0 + 26*x1 + 8*x2 >= 44)
m.addConstr(14*x0 + 8*x2 + x3 >= 44)
m.addConstr(26*x1 + 8*x2 + x3 >= 67)
m.addConstr(14*x0 + 26*x1 + 8*x2 >= 67)
m.addConstr(14*x0 + 8*x2 + x3 >= 67)
m.addConstr(17*x0 + 18*x1 + 16*x2 + 21*x3 >= 22)
m.addConstr(17*x0 + 21*x3 >= 19)
m.addConstr(17*x0 + 18*x1 >= 25)
m.addConstr(16*x2 + 21*x3 >= 22)
m.addConstr(20*x0 + 27*x1 + 26*x2 + 23*x3 >= 31)
m.addConstr(27*x1 + 23*x3 >= 36)
m.addConstr(26*x2 + 23*x3 >= 22)
m.addConstr(20*x0 + 27*x1 + 26*x2 >= 24)
m.addConstr(20*x0 + 26*x2 + 23*x3 >= 24)
m.addConstr(27*x1 + 26*x2 + 23*x3 >= 24)
m.addConstr(7*x0 - x1 >= 0)
m.addConstr(7*x1 + 6*x3 <= 112)
m.addConstr(6*x2 + 6*x3 <= 39)
m.addConstr(11*x0 + 6*x3 <= 111)
m.addConstr(11*x0 + 6*x2 <= 83)
m.addConstr(17*x0 + 18*x1 <= 42)
m.addConstr(16*x2 + 21*x3 <= 78)
m.addConstr(20*x0 + 26*x2 + 23*x3 <= 37)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("cornichons: ", x0.varValue)
    print("peanutbutter sandwiches: ", x1.varValue)
    print("oreos: ", x2.varValue)
    print("corn cobs: ", x3.varValue)
else:
    print("The model is infeasible")
