
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
water_purification_units = m.addVar(vtype=gp.GRB.INTEGER, name="x0")
reconnaissance_troops = m.addVar(vtype=gp.GRB.INTEGER, name="x1")
logistics_companies = m.addVar(vtype=gp.GRB.INTEGER, name="x2")
engineer_platoons = m.addVar(vtype=gp.GRB.INTEGER, name="x3")


# Set objective function
m.setObjective(1 * water_purification_units + 8 * reconnaissance_troops + 2 * logistics_companies + 6 * engineer_platoons, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.47 * reconnaissance_troops + 2.31 * logistics_companies >= 76)
m.addConstr(2.47 * reconnaissance_troops + 3.92 * engineer_platoons >= 82)
m.addConstr(2.85 * water_purification_units + 2.47 * reconnaissance_troops >= 38)
m.addConstr(2.31 * logistics_companies + 3.92 * engineer_platoons >= 43)
m.addConstr(2.85 * water_purification_units + 2.31 * logistics_companies + 3.92 * engineer_platoons >= 66)
m.addConstr(2.47 * reconnaissance_troops + 2.31 * logistics_companies + 3.92 * engineer_platoons >= 66)
m.addConstr(2.85 * water_purification_units + 2.31 * logistics_companies + 3.92 * engineer_platoons >= 83)
m.addConstr(2.47 * reconnaissance_troops + 2.31 * logistics_companies + 3.92 * engineer_platoons >= 83)
m.addConstr(2.85 * water_purification_units + 2.47 * reconnaissance_troops + 2.31 * logistics_companies + 3.92 * engineer_platoons >= 83)
m.addConstr(3.17 * reconnaissance_troops + 1.13 * logistics_companies >= 45)
m.addConstr(2.63 * water_purification_units + 0.77 * engineer_platoons >= 25)
m.addConstr(1.13 * logistics_companies + 0.77 * engineer_platoons >= 23)
m.addConstr(2.63 * water_purification_units + 3.17 * reconnaissance_troops + 1.13 * logistics_companies + 0.77 * engineer_platoons >= 23)
m.addConstr(0.81 * logistics_companies + 3.42 * engineer_platoons >= 15)
m.addConstr(0.3 * water_purification_units + 0.81 * logistics_companies >= 29)
m.addConstr(0.3 * water_purification_units + 0.81 * logistics_companies + 3.42 * engineer_platoons >= 40)
m.addConstr(0.3 * water_purification_units + 3.42 * reconnaissance_troops + 0.81 * logistics_companies + 3.42 * engineer_platoons >= 40)
m.addConstr(3.88 * water_purification_units + 2.23 * reconnaissance_troops >= 61)
m.addConstr(1.59 * logistics_companies + 1.29 * engineer_platoons >= 47)
m.addConstr(3.88 * water_purification_units + 2.23 * reconnaissance_troops + 1.59 * logistics_companies + 1.29 * engineer_platoons >= 47)
m.addConstr(0.04 * logistics_companies + 0.66 * engineer_platoons >= 102)
m.addConstr(2.89 * reconnaissance_troops + 0.04 * logistics_companies >= 75)
m.addConstr(1.1 * water_purification_units + 0.66 * engineer_platoons >= 80)
m.addConstr(1.1 * water_purification_units + 2.89 * reconnaissance_troops >= 55)
m.addConstr(1.1 * water_purification_units + 2.89 * reconnaissance_troops + 0.04 * logistics_companies >= 93)
m.addConstr(2.89 * reconnaissance_troops + 0.04 * logistics_companies + 0.66 * engineer_platoons >= 93)
m.addConstr(1.1 * water_purification_units + 2.89 * reconnaissance_troops + 0.04 * logistics_companies >= 65)
m.addConstr(2.89 * reconnaissance_troops + 0.04 * logistics_companies + 0.66 * engineer_platoons >= 65)
m.addConstr(1.1 * water_purification_units + 2.89 * reconnaissance_troops + 0.04 * logistics_companies + 0.66 * engineer_platoons >= 65)
m.addConstr(-2 * water_purification_units + 4 * engineer_platoons >= 0)
m.addConstr(9 * reconnaissance_troops - 8 * logistics_companies >= 0)
m.addConstr(2.31 * logistics_companies + 3.92 * engineer_platoons <= 149)
m.addConstr(2.85 * water_purification_units + 2.47 * reconnaissance_troops <= 86)
m.addConstr(2.85 * water_purification_units + 3.92 * engineer_platoons <= 217)
m.addConstr(2.63 * water_purification_units + 1.13 * logistics_companies <= 181)
m.addConstr(1.13 * logistics_companies + 0.77 * engineer_platoons <= 218)
m.addConstr(3.17 * reconnaissance_troops + 1.13 * logistics_companies <= 191)
m.addConstr(0.3 * water_purification_units + 3.42 * reconnaissance_troops + 0.81 * logistics_companies <= 184)
m.addConstr(0.3 * water_purification_units + 0.81 * logistics_companies + 3.42 * engineer_platoons <= 168)
m.addConstr(1.1 * water_purification_units + 0.66 * engineer_platoons <= 298)
m.addConstr(2.89 * reconnaissance_troops + 0.04 * logistics_companies <= 220)
m.addConstr(1.1 * water_purification_units + 2.89 * reconnaissance_troops + 0.66 * engineer_platoons <= 339)

# Resource Constraints
m.addConstr(2.85 * water_purification_units + 2.47 * reconnaissance_troops + 2.31 * logistics_companies + 3.92 * engineer_platoons <= 341)
m.addConstr(2.63 * water_purification_units + 3.17 * reconnaissance_troops + 1.13 * logistics_companies + 0.77 * engineer_platoons <= 285)
m.addConstr(0.3 * water_purification_units + 3.42 * reconnaissance_troops + 0.81 * logistics_companies + 3.42 * engineer_platoons <= 189)
m.addConstr(3.88 * water_purification_units + 2.23 * reconnaissance_troops + 1.59 * logistics_companies + 1.29 * engineer_platoons <= 269)
m.addConstr(1.1 * water_purification_units + 2.89 * reconnaissance_troops + 0.04 * logistics_companies + 0.66 * engineer_platoons <= 436)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

