
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
red_pens = m.addVar(vtype=gp.GRB.INTEGER, name="red_pens")
smoke_detectors = m.addVar(vtype=gp.GRB.INTEGER, name="smoke_detectors")
usb_flash_drives = m.addVar(vtype=gp.GRB.INTEGER, name="usb_flash_drives")
red_highlighters = m.addVar(vtype=gp.GRB.INTEGER, name="red_highlighters")


# Set objective function
m.setObjective(7 * red_pens + 9 * smoke_detectors + 1 * usb_flash_drives + 8 * red_highlighters, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.33 * red_pens + 5.97 * smoke_detectors + 0.49 * usb_flash_drives + 8.39 * red_highlighters <= 181, "c0")
m.addConstr(8.92 * red_pens + 0.35 * smoke_detectors + 1.97 * usb_flash_drives + 9.01 * red_highlighters <= 205, "c1")
m.addConstr(5.97 * smoke_detectors + 8.39 * red_highlighters >= 40, "c2")
m.addConstr(1.33 * red_pens + 5.97 * smoke_detectors >= 22, "c3")
m.addConstr(1.33 * red_pens + 5.97 * smoke_detectors + 8.39 * red_highlighters >= 26, "c4")
m.addConstr(1.33 * red_pens + 5.97 * smoke_detectors + 0.49 * usb_flash_drives + 8.39 * red_highlighters >= 26, "c5")
m.addConstr(8.92 * red_pens + 1.97 * usb_flash_drives >= 18, "c6")
m.addConstr(0.35 * smoke_detectors + 1.97 * usb_flash_drives >= 21, "c7")
m.addConstr(0.35 * smoke_detectors + 1.97 * usb_flash_drives + 9.01 * red_highlighters >= 45, "c8")
m.addConstr(8.92 * red_pens + 0.35 * smoke_detectors + 1.97 * usb_flash_drives >= 45, "c9")
m.addConstr(8.92 * red_pens + 1.97 * usb_flash_drives + 9.01 * red_highlighters >= 45, "c10")
m.addConstr(0.35 * smoke_detectors + 1.97 * usb_flash_drives + 9.01 * red_highlighters >= 48, "c11")
m.addConstr(8.92 * red_pens + 0.35 * smoke_detectors + 1.97 * usb_flash_drives >= 48, "c12")
m.addConstr(8.92 * red_pens + 1.97 * usb_flash_drives + 9.01 * red_highlighters >= 48, "c13")
m.addConstr(0.35 * smoke_detectors + 1.97 * usb_flash_drives + 9.01 * red_highlighters >= 35, "c14")
m.addConstr(8.92 * red_pens + 0.35 * smoke_detectors + 1.97 * usb_flash_drives >= 35, "c15")
m.addConstr(8.92 * red_pens + 1.97 * usb_flash_drives + 9.01 * red_highlighters >= 35, "c16")
m.addConstr(8.92 * red_pens + 0.35 * smoke_detectors + 1.97 * usb_flash_drives + 9.01 * red_highlighters >= 35, "c17")
m.addConstr(-9 * usb_flash_drives + 7 * red_highlighters >= 0, "c18")
m.addConstr(-8 * red_pens + 6 * red_highlighters >= 0, "c19")
m.addConstr(5.97 * smoke_detectors + 8.39 * red_highlighters <= 83, "c20")
m.addConstr(1.33 * red_pens + 5.97 * smoke_detectors + 0.49 * usb_flash_drives <= 99, "c21")
m.addConstr(1.33 * red_pens + 5.97 * smoke_detectors + 8.39 * red_highlighters <= 154, "c22")
m.addConstr(8.92 * red_pens + 0.35 * smoke_detectors <= 187, "c23")
m.addConstr(0.35 * smoke_detectors + 9.01 * red_highlighters <= 68, "c24")
m.addConstr(0.35 * smoke_detectors + 1.97 * usb_flash_drives + 9.01 * red_highlighters <= 54, "c25")
m.addConstr(8.92 * red_pens + 1.97 * usb_flash_drives + 9.01 * red_highlighters <= 144, "c26")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

