
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='x0', vtype='I')  # red pens
x1 = model.addVar(name='x1', vtype='I')  # smoke detectors
x2 = model.addVar(name='x2', vtype='I')  # usb flash drives
x3 = model.addVar(name='x3', vtype='I')  # red highlighters

# Objective function
model.setObjective(7 * x0 + 9 * x1 + x2 + 8 * x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(1.33 * x0 + 5.97 * x1 + 0.49 * x2 + 8.39 * x3 <= 181)
model.addConstr(8.92 * x0 + 0.35 * x1 + 1.97 * x2 + 9.01 * x3 <= 205)
model.addConstr(5.97 * x1 + 8.39 * x3 >= 40)
model.addConstr(1.33 * x0 + 5.97 * x1 >= 22)
model.addConstr(1.33 * x0 + 5.97 * x1 + 8.39 * x3 >= 26)
model.addConstr(1.33 * x0 + 5.97 * x1 + 0.49 * x2 + 8.39 * x3 >= 26)
model.addConstr(8.92 * x0 + 1.97 * x2 >= 18)
model.addConstr(0.35 * x1 + 1.97 * x2 >= 21)
model.addConstr(0.35 * x1 + 1.97 * x2 + 9.01 * x3 >= 45)
model.addConstr(8.92 * x0 + 0.35 * x1 + 1.97 * x2 >= 45)
model.addConstr(8.92 * x0 + 1.97 * x2 + 9.01 * x3 >= 45)
model.addConstr(0.35 * x1 + 1.97 * x2 + 9.01 * x3 >= 48)
model.addConstr(8.92 * x0 + 0.35 * x1 + 1.97 * x2 >= 48)
model.addConstr(8.92 * x0 + 1.97 * x2 + 9.01 * x3 >= 48)
model.addConstr(0.35 * x1 + 1.97 * x2 + 9.01 * x3 >= 35)
model.addConstr(8.92 * x0 + 0.35 * x1 + 1.97 * x2 >= 35)
model.addConstr(8.92 * x0 + 1.97 * x2 + 9.01 * x3 >= 35)
model.addConstr(8.92 * x0 + 0.35 * x1 + 1.97 * x2 + 9.01 * x3 >= 35)
model.addConstr(-9 * x2 + 7 * x3 >= 0)
model.addConstr(-8 * x0 + 6 * x3 >= 0)
model.addConstr(5.97 * x1 + 8.39 * x3 <= 83)
model.addConstr(1.33 * x0 + 5.97 * x1 + 0.49 * x2 <= 99)
model.addConstr(1.33 * x0 + 5.97 * x1 + 8.39 * x3 <= 154)
model.addConstr(8.92 * x0 + 0.35 * x1 <= 187)
model.addConstr(0.35 * x1 + 9.01 * x3 <= 68)
model.addConstr(0.35 * x1 + 1.97 * x2 + 9.01 * x3 <= 54)
model.addConstr(8.92 * x0 + 1.97 * x2 + 9.01 * x3 <= 144)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('No optimal solution found')
