
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Dale")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hours worked by Bill")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="hours worked by Jean")


    # Set objective function
    m.setObjective(6.51 * x0 + 1.32 * x1 + 8.09 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2.63 * x1 + 10.46 * x2 >= 68)
    m.addConstr(15.46 * x0 + 20.64 * x1 <= 107)
    m.addConstr(15.46 * x0 + 19.1 * x2 <= 107)
    m.addConstr(15.46 * x0 + 20.64 * x1 + 19.1 * x2 <= 222)
    m.addConstr(7.59 * x0 + 17.15 * x1 <= 144)
    m.addConstr(17.15 * x1 + 12.66 * x2 <= 286)
    m.addConstr(7.59 * x0 + 17.15 * x1 + 12.66 * x2 <= 260)
    m.addConstr(19.96 * x0 + 10.46 * x2 <= 341)
    m.addConstr(19.96 * x0 + 2.63 * x1 + 10.46 * x2 <= 222)
    m.addConstr(13.21 * x1 + 2.47 * x2 <= 110)
    m.addConstr(6.49 * x0 + 2.47 * x2 <= 224)
    m.addConstr(6.49 * x0 + 13.21 * x1 + 2.47 * x2 <= 155)
    m.addConstr(2.55 * x1 + 3.83 * x2 <= 217)
    m.addConstr(1.9 * x0 + 2.55 * x1 <= 191)
    m.addConstr(1.9 * x0 + 2.55 * x1 + 3.83 * x2 <= 191)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
