
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
x1 = model.addVar(name="x1", vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Bill
x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Jean

# Define the objective function
model.setObjective(6.51 * x0 + 1.32 * x1 + 8.09 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(19.96 * x0 <= 363)  
model.addConstr(7.59 * x0 <= 328)  
model.addConstr(15.46 * x0 <= 257)  
model.addConstr(6.49 * x0 <= 280)  
model.addConstr(1.9 * x0 <= 279)  

model.addConstr(2.63 * x1 <= 363)  
model.addConstr(17.15 * x1 <= 328)  
model.addConstr(20.64 * x1 <= 257)  
model.addConstr(13.21 * x1 <= 280)  
model.addConstr(2.55 * x1 <= 279)  

model.addConstr(10.46 * x2 <= 363)  
model.addConstr(12.66 * x2 <= 328)  
model.addConstr(19.1 * x2 <= 257)  
model.addConstr(2.47 * x2 <= 280)  
model.addConstr(3.83 * x2 <= 279)  

model.addConstr(2.63 * x1 + 10.46 * x2 >= 68)  
model.addConstr(15.46 * x0 + 20.64 * x1 <= 107)  
model.addConstr(15.46 * x0 + 19.1 * x2 <= 107)  
model.addConstr(15.46 * x0 + 20.64 * x1 + 19.1 * x2 <= 222)  

model.addConstr(7.59 * x0 + 17.15 * x1 <= 144)  
model.addConstr(17.15 * x1 + 12.66 * x2 <= 286)  
model.addConstr(7.59 * x0 + 17.15 * x1 + 12.66 * x2 <= 260)  

model.addConstr(19.96 * x0 + 10.46 * x2 <= 341)  
model.addConstr(19.96 * x0 + 2.63 * x1 + 10.46 * x2 <= 222)  

model.addConstr(13.21 * x1 + 2.47 * x2 <= 110)  
model.addConstr(6.49 * x0 + 2.47 * x2 <= 224)  
model.addConstr(6.49 * x0 + 13.21 * x1 + 2.47 * x2 <= 155)  

model.addConstr(2.55 * x1 + 3.83 * x2 <= 217)  
model.addConstr(1.9 * x0 + 2.55 * x1 <= 191)  
model.addConstr(1.9 * x0 + 2.55 * x1 + 3.83 * x2 <= 191)  

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
