
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, names=['milkshakes', 'bowls_of_cereal', 'hot_dogs', 'kale_salads', 'ravioli'])


# Set objective function
objective = 8.26*x[0]**2 + 6.29*x[0]*x[1] + 5.17*x[0]*x[2] + 9.02*x[0]*x[3] + 4.68*x[0]*x[4] + 6.36*x[1]**2 + 4.2*x[1]*x[2] + 6.29*x[1]*x[3] + 3.33*x[1]*x[4] + 8.22*x[2]**2 + 7.14*x[2]*x[3] + 9.06*x[2]*x[4] + 3.84*x[3]**2 + 7.38*x[3]*x[4] + 8.11*x[4]**2 + 5.69*x[0] + 5.73*x[1] + 9.5*x[2] + 9.78*x[3] + 3.99*x[4]
m.setObjective(objective, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14.32*x[0] + 16.47*x[1] + 19.27*x[2] + 16.95*x[3] + 19.77*x[4] <= 378)
m.addConstr(6.96*x[0] + 14.12*x[1] + 8.59*x[2] + 9.72*x[3] + 14.01*x[4] <= 415)
m.addConstr(19.27*x[2] + 16.95*x[3] >= 72)
m.addConstr(16.47*x[1] + 19.77*x[4] >= 75)
m.addConstr(6.96*x[0] + 14.12*x[1] + 9.72*x[3] >= 76)
m.addConstr((14.12*x[1])**2 + (9.72*x[3])**2 + (14.01*x[4])**2 >= 76)
m.addConstr(6.96*x[0] + 14.12*x[1] + 9.72*x[3] >= 55)
m.addConstr((14.12*x[1])**2 + (9.72*x[3])**2 + (14.01*x[4])**2 >= 55)
m.addConstr(14.32*x[0] + 19.77*x[4] <= 300)
m.addConstr((14.32*x[0])**2 + (16.47*x[1])**2 <= 122)
m.addConstr(16.47*x[1] + 19.27*x[2] <= 79)
m.addConstr((14.32*x[0])**2 + (16.95*x[3])**2 <= 205)
m.addConstr((16.95*x[3])**2 + (19.77*x[4])**2 <= 186)
m.addConstr(14.32*x[0] + 16.47*x[1] + 19.27*x[2] + 16.95*x[3] + 19.77*x[4] <= 186)
m.addConstr((9.72*x[3])**2 + (14.01*x[4])**2 <= 195)
m.addConstr((6.96*x[0])**2 + (8.59*x[2])**2 <= 415)
m.addConstr(6.96*x[0] + 9.72*x[3] <= 116)
m.addConstr(8.59*x[2] + 9.72*x[3] <= 187)
m.addConstr((14.12*x[1])**2 + (14.01*x[4])**2 <= 284)
m.addConstr(6.96*x[0] + 14.12*x[1] + 14.01*x[4] <= 285)
m.addConstr(6.96*x[0] + 8.59*x[2] + 14.01*x[4] <= 224)
m.addConstr((14.12*x[1])**2 + (8.59*x[2])**2 + (14.01*x[4])**2 <= 197)
m.addConstr(6.96*x[0] + 14.12*x[1] + 9.72*x[3] <= 323)
m.addConstr(6.96*x[0] + 14.12*x[1] + 8.59*x[2] + 9.72*x[3] + 14.01*x[4] <= 323)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

