
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="x1", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="x2", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)

    # Define objective function
    model.setObjective(2*x0 + 2*x1 + 5*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6*x0 + 8*x1 + 9*x2 >= 12)
    model.addConstr(6*x0 + 8*x1 >= 10)
    model.addConstr(6*x0 + 9*x2 >= 12)
    model.addConstr(6*x0 + 3*x1 + 8*x2 >= 29)
    model.addConstr(6*x0 + 3*x1 >= 25)
    model.addConstr(6*x0 + 8*x2 >= 33)
    model.addConstr(3*x1 + 8*x2 >= 29)
    model.addConstr(7*x1 + 9*x2 >= 12)
    model.addConstr(4*x0 + 9*x2 >= 10)
    model.addConstr(4*x0 + 7*x1 >= 13)
    model.addConstr(4*x0 + 7*x1 + 9*x2 >= 12)
    model.addConstr(-4*x0 + 2*x1 >= 0)
    model.addConstr(-9*x0 + 3*x2 >= 0)
    model.addConstr(4*x0 + 9*x2 <= 45)
    model.addConstr(4*x0 + 7*x1 <= 58)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {x0.varValue}")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
