
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("Plant_Optimization")

    # Create variables
    zucchini = m.addVar(vtype=GRB.INTEGER, name="zucchini")
    pansies = m.addVar(vtype=GRB.INTEGER, name="pansies")


    # Set objective function
    m.setObjective(9.72 * zucchini + 5.74 * pansies, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7 * zucchini + 7 * pansies >= 25 * 144, "planting_space_min")  # 25 sq ft minimum planting space
    m.addConstr(6 * zucchini + 1 * pansies >= 20, "beauty_rating_min")      # Minimum beauty rating
    m.addConstr(-7 * zucchini + 7 * pansies >= 0, "zucchini_pansies_relation") # Relationship between zucchini and pansies
    m.addConstr(7 * zucchini + 7 * pansies <= 40 * 144, "planting_space_max")  # 40 sq ft maximum planting space
    m.addConstr(6 * zucchini + 1 * pansies <= 45, "beauty_rating_max")      # Maximum beauty rating


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Zucchini vines: {zucchini.x}")
        print(f"  Pansies: {pansies.x}")
        print(f"  Objective value: {m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
