
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="zucchini_vines")
x2 = m.addVar(vtype=GRB.INTEGER, name="pansies")

# Set the objective function
m.setObjective(9.72*x1 + 5.74*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 7*x2 >= 3600, "min_total_space")
m.addConstr(7*x1 + 7*x2 <= 4800, "max_total_space")
m.addConstr(6*x1 + x2 >= 20, "min_beauty_rating")
m.addConstr(6*x1 + x2 <= 45, "max_beauty_rating")
m.addConstr(-7*x1 + 7*x2 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Zucchini vines: {x1.x}")
    print(f"Pansies: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
