
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="zucchini_vines", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="pansies", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9.72 * x1 + 5.74 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * x1 + 7 * x2 >= 3600, name="planting_space_min")
    model.addConstr(6 * x1 + x2 >= 20, name="beauty_rating_min")
    model.addConstr(-7 * x1 + 7 * x2 >= 0, name="balance_constraint")
    model.addConstr(7 * x1 + 7 * x2 <= 5760, name="planting_space_max")
    model.addConstr(6 * x1 + x2 <= 45, name="beauty_rating_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Zucchini vines: {x1.varValue}")
        print(f"Pansies: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
