
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    steaks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steaks")
    kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
    pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")


    # Set objective function
    m.setObjective(1.31 * steaks + 1.16 * kale_salads + 9.2 * pickles, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1 * steaks + 5 * kale_salads >= 5, "c0")
    m.addConstr(1 * steaks + 5 * kale_salads + 2 * pickles >= 5, "c1")
    m.addConstr(1 * steaks + 5 * pickles >= 5, "c2")
    m.addConstr(2 * kale_salads + 5 * pickles >= 4, "c3")
    m.addConstr(1 * steaks + 2 * kale_salads >= 12, "c4")
    m.addConstr(1 * steaks + 2 * kale_salads + 5 * pickles >= 8, "c5")
    m.addConstr(4 * steaks + 5 * pickles >= 6, "c6")
    m.addConstr(3 * kale_salads + 5 * pickles >= 5, "c7")
    m.addConstr(4 * steaks + 3 * kale_salads + 5 * pickles >= 5, "c8")
    m.addConstr(10 * steaks - 7 * pickles >= 0, "c9")
    m.addConstr(1 * steaks + 5 * kale_salads <= 27, "c10")
    m.addConstr(1 * steaks + 5 * kale_salads + 2 * pickles <= 46, "c11")
    m.addConstr(1 * steaks + 2 * kale_salads <= 34, "c12")

    # Resource constraints
    m.addConstr(1 * steaks + 5 * kale_salads + 2 * pickles <= 48, "tastiness")
    m.addConstr(1 * steaks + 2 * kale_salads + 5 * pickles <= 41, "fiber")
    m.addConstr(4 * steaks + 3 * kale_salads + 5 * pickles <= 24, "carbs")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
