
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B1
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # grams of fat
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B2


    # Set objective function
    model.setObjective(3*x0 + 9*x1 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6*x0 + 1*x1 + 2*x2 <= 69, "c0")
    model.addConstr(3*x0 + 5*x1 + 7*x2 <= 64, "c1")
    model.addConstr(4*x0 + 3*x1 + 6*x2 <= 50, "c2")
    model.addConstr(8*x0 + 5*x1 + 8*x2 <= 57, "c3")
    model.addConstr(1*x1 + 2*x2 >= 8, "c4")
    model.addConstr(6*x0 + 1*x1 + 2*x2 >= 8, "c5")
    model.addConstr(5*x1 + 7*x2 >= 7, "c6")
    model.addConstr(3*x0 + 5*x1 + 7*x2 >= 7, "c7")
    model.addConstr(3*x1 + 6*x2 >= 12, "c8")
    model.addConstr(4*x0 + 3*x1 + 6*x2 >= 12, "c9")
    model.addConstr(8*x0 + 5*x1 >= 9, "c10")
    model.addConstr(8*x0 + 8*x2 >= 12, "c11")
    model.addConstr(8*x0 + 5*x1 + 8*x2 >= 12, "c12")
    model.addConstr(3*x1 - 4*x2 >= 0, "c13")
    model.addConstr(-9*x0 + 9*x1 >= 0, "c14")
    model.addConstr(4*x0 + 6*x2 <= 45, "c15")
    model.addConstr(4*x0 + 3*x1 <= 18, "c16")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
