
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
potassium = m.addVar(vtype=gp.GRB.INTEGER, name="potassium")
vitamin_b5 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
zinc = m.addVar(vtype=gp.GRB.INTEGER, name="zinc")
vitamin_e = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_e")
vitamin_a = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_a")
calcium = m.addVar(vtype=gp.GRB.INTEGER, name="calcium")
fiber = m.addVar(vtype=gp.GRB.INTEGER, name="fiber")


# Set objective function
m.setObjective(8.94 * potassium + 8.74 * vitamin_b5 + 4.2 * zinc + 4.2 * vitamin_e + 3.65 * vitamin_a + 5.29 * calcium + 4.49 * fiber, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * potassium + 16 * vitamin_b5 + 2 * zinc + 10 * vitamin_e + 12 * vitamin_a + 16 * calcium + 2 * fiber <= 574, "r0")
m.addConstr(7 * potassium + 11 * vitamin_b5 + 16 * zinc + 15 * vitamin_e + 1 * vitamin_a + 4 * calcium + 11 * fiber <= 686, "r1")

# ... (add all other constraints similarly, replacing variable names)

# Add non-negativity constraints explicitly
m.addConstr(potassium >= 0)
m.addConstr(vitamin_b5 >= 0)
m.addConstr(zinc >= 0)
m.addConstr(vitamin_e >= 0)
m.addConstr(vitamin_a >= 0)
m.addConstr(calcium >= 0)
m.addConstr(fiber >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

