
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize_Hours")

    # Create variables
    hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
    bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
    paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
    george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
    ringo = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo")


    # Set objective function
    model.setObjective(9*hank + 6*bobby + 1*paul + 9*george + 8*ringo, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12*bobby + 7*ringo >= 31, "c1")
    model.addConstr(14*paul + 7*ringo >= 41, "c2")
    model.addConstr(13*hank + 14*paul >= 25, "c3")
    model.addConstr(13*hank + 12*bobby + 14*paul + 4*george + 7*ringo >= 25, "c4")
    model.addConstr(-2*hank + 1*ringo >= 0, "c5")
    model.addConstr(12*bobby + 4*george <= 170, "c6")
    model.addConstr(14*paul + 4*george <= 154, "c7")
    model.addConstr(13*hank + 7*ringo <= 137, "c8")
    model.addConstr(14*paul + 7*ringo <= 160, "c9")
    model.addConstr(13*hank + 12*bobby <= 156, "c10")
    model.addConstr(12*bobby + 7*ringo <= 125, "c11")
    model.addConstr(13*hank + 4*george <= 75, "c12")
    model.addConstr(12*bobby + 14*paul <= 79, "c13")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
