
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='x1', lb=0)  # hours worked by Hank
x2 = m.addVar(name='x2', lb=0)  # hours worked by Bobby
x3 = m.addVar(name='x3', lb=0)  # hours worked by Paul
x4 = m.addVar(name='x4', lb=0)  # hours worked by George
x5 = m.addVar(name='x5', lb=0, vtype='I')  # hours worked by Ringo

# Objective function
m.setObjective(9*x1 + 6*x2 + x3 + 9*x4 + 8*x5, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(12*x2 + 7*x5 >= 31)
m.addConstr(14*x3 + 7*x5 >= 41)
m.addConstr(13*x1 + 14*x3 >= 25)
m.addConstr(13*x1 + 12*x2 + 14*x3 + 4*x4 + 7*x5 >= 25)
m.addConstr(-2*x1 + x5 >= 0)
m.addConstr(12*x2 + 4*x4 <= 170)
m.addConstr(14*x3 + 4*x4 <= 154)
m.addConstr(13*x1 + 7*x5 <= 137)
m.addConstr(14*x3 + 7*x5 <= 160)
m.addConstr(13*x1 + 12*x2 <= 156)
m.addConstr(12*x2 + 7*x5 <= 125)
m.addConstr(13*x1 + 4*x4 <= 75)
m.addConstr(12*x2 + 14*x3 <= 79)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Hours worked by Hank: ', x1.varValue)
    print('Hours worked by Bobby: ', x2.varValue)
    print('Hours worked by Paul: ', x3.varValue)
    print('Hours worked by George: ', x4.varValue)
    print('Hours worked by Ringo: ', x5.varValue)
else:
    print('The model is infeasible')
