
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    bagged_salads = m.addVar(vtype=GRB.CONTINUOUS, name="bagged_salads")
    kiwis = m.addVar(vtype=GRB.CONTINUOUS, name="kiwis")
    strips_of_bacon = m.addVar(vtype=GRB.CONTINUOUS, name="strips_of_bacon")


    # Set objective function
    m.setObjective(5.76*bagged_salads**2 + 7.22*kiwis*strips_of_bacon + 7.84*strips_of_bacon**2 + 2.36*strips_of_bacon, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(18*kiwis**2 + 7*strips_of_bacon**2 >= 62, "iron_constraint1")
    m.addConstr(20*bagged_salads + 7*strips_of_bacon >= 99, "iron_constraint2")
    m.addConstr(18*kiwis**2 + 7*strips_of_bacon**2 <= 221, "iron_constraint3")
    m.addConstr(20*bagged_salads**2 + 7*strips_of_bacon**2 <= 203, "iron_constraint4")
    m.addConstr(20*bagged_salads + 18*kiwis + 7*strips_of_bacon <= 203, "iron_constraint5")



    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('bagged_salads:', bagged_salads.x)
        print('kiwis:', kiwis.x)
        print('strips_of_bacon:', strips_of_bacon.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
