
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='bagged_salads', lb=-GRB.INFINITY, ub=GRB.INFINITY)
x1 = m.addVar(name='kiwis', lb=-GRB.INFINITY, ub=GRB.INFINITY)
x2 = m.addVar(name='strips_of_bacon', lb=-GRB.INFINITY, ub=GRB.INFINITY)

# Objective function
m.setObjective(5.76*x0**2 + 7.22*x1*x2 + 7.84*x2**2 + 2.36*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x1**2 + x2**2 >= 62)
m.addConstr(20*x0 + 7*x2 >= 99)
m.addConstr(x1**2 + x2**2 <= 221)
m.addConstr(x0**2 + x2**2 <= 203)
m.addConstr(20*x0 + 18*x1 + 7*x2 <= 203)

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bagged salads: {x0.x}")
    print(f"Kiwis: {x1.x}")
    print(f"Strips of bacon: {x2.x}")
else:
    print("No optimal solution found.")
