
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="bagged_salads", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="kiwis", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = m.addVar(name="strips_of_bacon", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
m.setObjective(5.76 * x1**2 + 7.22 * x2 * x3 + 7.84 * x3**2 + 2.36 * x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(20 * x1 + 18 * x2 + 7 * x3 <= 300)
m.addConstr(18**2 * x2**2 + 7**2 * x3**2 >= 62)
m.addConstr(20 * x1 + 7 * x3 >= 99)
m.addConstr(18**2 * x2**2 + 7**2 * x3**2 <= 221)
m.addConstr(20**2 * x1**2 + 7**2 * x3**2 <= 203)
m.addConstr(20 * x1 + 18 * x2 + 7 * x3 <= 203)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bagged salads: ", x1.varValue)
    print("kiwis: ", x2.varValue)
    print("strips of bacon: ", x3.varValue)
else:
    print("The model is infeasible")
