
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


    # Set objective function
    m.setObjective(3*x0 + 9*x1 + 2*x2 + 2*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6*x1 + 18*x3 >= 36)
    m.addConstr(6*x0 + 21*x2 >= 33)
    m.addConstr(6*x1 + 21*x2 >= 62)
    m.addConstr(21*x2 + 18*x3 >= 60)
    m.addConstr(6*x0 + 6*x1 + 21*x2 >= 53)
    m.addConstr(6*x0 + 21*x2 + 18*x3 >= 53)
    m.addConstr(6*x0 + 6*x1 + 21*x2 >= 42)
    m.addConstr(6*x0 + 21*x2 + 18*x3 >= 42)
    m.addConstr(9*x1 + 8*x2 >= 24)
    m.addConstr(13*x0 + 12*x3 >= 33)
    m.addConstr(9*x1 + 12*x3 >= 48)
    m.addConstr(13*x0 + 8*x2 >= 31)
    m.addConstr(8*x2 + 12*x3 >= 27)
    m.addConstr(6*x0 + 18*x3 <= 185)
    m.addConstr(21*x2 + 18*x3 <= 217)
    m.addConstr(6*x1 + 21*x2 <= 95)
    m.addConstr(6*x0 + 6*x1 + 21*x2 + 18*x3 <= 95)
    m.addConstr(13*x0 + 8*x2 <= 237)
    m.addConstr(8*x2 + 12*x3 <= 145)
    m.addConstr(13*x0 + 12*x3 <= 128)
    m.addConstr(13*x0 + 9*x1 + 8*x2 + 12*x3 <= 128)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Other optimization status')

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
